# -*- coding: utf-8 -*-
"""
BIG Downloader Toolbox Provider - SIMPLIFIED VERSION
"""

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os

class BIGDownloaderToolboxProvider(QgsProcessingProvider):
    """Provider untuk BIG Downloader Toolbox"""
    
    def __init__(self):
        super().__init__()
    
    def loadAlgorithms(self):
        """Load all algorithms"""
        try:
            # Load algorithm modules directly
            from .algorithms.login_demnas import LoginDEMNAS
            from .algorithms.download_demnas_pro import DownloadDemnasPro
            from .algorithms.download_rbi_tool_pro import DownloadRBIToolPro
            from .algorithms.download_batnas import DownloadBATNAS
            
            # Add algorithms
            self.addAlgorithm(LoginDEMNAS())
            self.addAlgorithm(DownloadDemnasPro())
            self.addAlgorithm(DownloadRBIToolPro())
            self.addAlgorithm(DownloadBATNAS())
            
            print("✅ All algorithms loaded successfully")
            
        except Exception as e:
            print(f"❌ Error loading algorithms: {str(e)}")
            import traceback
            traceback.print_exc()
    
    def id(self):
        """Unique provider ID"""
        return 'big_downloader_toolbox'
    
    def name(self):
        """Provider name"""
        return 'BIG Downloader Toolbox'
    
    def icon(self):
        """Provider icon"""
        # Coba icon utama dulu
        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        if os.path.exists(icon_path):
            return QIcon(icon_path)
        
        # Fallback ke default icon
        return super().icon()
    
    def longName(self):
        """Long provider name"""
        return 'BIG Downloader Toolbox - Download DEMNAS, RBI, BATNAS'